VERSION 5.00
Begin VB.Form frmDemo 
   Caption         =   "Visual Basic Demo - Keithley Model 6517A & GPIB Interface"
   ClientHeight    =   7260
   ClientLeft      =   2490
   ClientTop       =   1815
   ClientWidth     =   8685
   LinkTopic       =   "Form1"
   ScaleHeight     =   7260
   ScaleWidth      =   8685
   Begin VB.ListBox lstResults 
      Height          =   1815
      Left            =   2160
      TabIndex        =   16
      Top             =   3840
      Width           =   4455
   End
   Begin VB.TextBox txtAddress 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   4200
      TabIndex        =   14
      Text            =   "27"
      Top             =   1320
      Width           =   1000
   End
   Begin VB.TextBox txtNrdgs 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   4200
      TabIndex        =   11
      Text            =   "5"
      Top             =   2280
      Width           =   1000
   End
   Begin VB.TextBox txtDelay 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   4200
      TabIndex        =   10
      Text            =   "2"
      Top             =   1800
      Width           =   1000
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   5400
      TabIndex        =   8
      Top             =   6120
      Width           =   1000
   End
   Begin VB.CommandButton cmdConfig 
      Caption         =   "Config 6517A"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   2520
      TabIndex        =   7
      Top             =   6120
      Width           =   1335
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   7080
      TabIndex        =   6
      Top             =   6120
      Width           =   1000
   End
   Begin VB.CommandButton cmdInstruct 
      Caption         =   "Show Instructions"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   480
      TabIndex        =   5
      Top             =   6120
      Width           =   1695
   End
   Begin VB.CommandButton cmdStart 
      BackColor       =   &H0000FF00&
      Caption         =   "Start"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   4080
      TabIndex        =   1
      Top             =   6120
      Width           =   1000
   End
   Begin VB.TextBox txtPoints 
      Appearance      =   0  'Flat
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   3450
      TabIndex        =   0
      Text            =   "Actual # of points in buffer"
      Top             =   3000
      Width           =   1065
   End
   Begin VB.Label Label4 
      Alignment       =   1  'Right Justify
      Caption         =   "Enter GPIB Address (0 to 30, Default =27):"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   240
      TabIndex        =   15
      Top             =   1380
      Width           =   3855
   End
   Begin VB.Label Label9 
      Alignment       =   1  'Right Justify
      Caption         =   "Enter Number of Readings:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   240
      TabIndex        =   13
      Top             =   2340
      Width           =   3855
   End
   Begin VB.Label Label8 
      Alignment       =   1  'Right Justify
      Caption         =   "Enter Time Between Readings (seconds):"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   240
      TabIndex        =   12
      Top             =   1860
      Width           =   3855
   End
   Begin VB.Label Label6 
      Alignment       =   2  'Center
      Caption         =   "###### Resistance - Timestamp - Vsource ######"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   1200
      TabIndex        =   9
      Top             =   3600
      Width           =   6000
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Label3 - Filled in via code"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   345
      TabIndex        =   4
      Top             =   120
      Width           =   6375
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Buffer Data:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   600
      TabIndex        =   3
      Top             =   3960
      Width           =   1455
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Total Number of Points:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   900
      TabIndex        =   2
      Top             =   3060
      Width           =   2415
   End
End
Attribute VB_Name = "frmDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' This program was written to work with Keithley (Capital Equip Corp - CEC) GPIB Interface Cards.
' It was tested using a Keithley Model KPCI-488 GPIB (IEEE-488.2) Interface Card.
' It is believed that other GPIB card manufacturers provide control subroutines for their cards,
'   similar to those provided by CEC in the GPIB_Subroutines Module (ieeevb.bas).

' a model 6517A with firmware B13 was used.  A 1G-Ohm resistor was connected as shown in
' Figure 2-31 in the 6517A User's Manual.

Option Explicit

'*** DECLARE FORM-LEVEL VARIABLES
Dim intDmmAddress As Integer        ' GPIB address for DMM
Dim intNrdgs As Integer             ' The number of measurements you want to make
Dim intDelay As Integer             ' The time between the start of consecutive measurements
Dim intStatus As Integer            ' Variable to receive GPIB communication status;
                                    '   use to check communication status if desired
Dim strBuffer As String             ' Variable to receive data output from 6517A;
                                    '   without specifying length, string will hold ~2 billion chars
Dim lngNbytes As Long               ' Actual number of bytes sent by DMM to controller;
                                    '   Type is LONG instead of INTEGER because of my change to ieeevb.bas;
                                    '   Use this value to redimension input string if desired
Dim intNpoints As Integer           ' Actual number of points in buffer
Dim strOhmsTimeVsrc() As String     ' String array to parse strBuffer into
Dim sngOhmsTime() As Single         ' Not used at this time

Private Sub cmdConfig_Click()   ' *** Subroutine performed when Config 6517A button is clicked ***
    
    intDmmAddress = Val(txtAddress.Text)    ' Set address variable to value entered in textbox
    intDelay = Val(txtDelay.Text)           ' Set delay variable to value entered in textbox
    intNrdgs = Val(txtNrdgs.Text)           ' Set reading variable to value entered in textbox
    
    '*** DO SOME INITIAL SETUP
    Call send(intDmmAddress, "*RST", intStatus)    ' Reset the 6517A; send() subroutine is in GPIB_Subroutines Module
    Call send(intDmmAddress, ":SYSTEM:ZCHECK ON", intStatus)            ' Turn on ZERO CHECK
    Call send(intDmmAddress, ":CALCULATE1:STATE OFF", intStatus)        ' Turn off MATH
    Call send(intDmmAddress, ":SOURCE:VOLTAGE:MCONNECT ON", intStatus)  ' Connect Vsource LO & ammeter LO internally
        
    '*** CONFIGURE AUTO VSOURCE OHMS MEASUREMENT
    Call send(intDmmAddress, ":SENSE:FUNCTION 'RESISTANCE'", intStatus)         ' Measure Resistance
    Call send(intDmmAddress, ":SENSE:RESISTANCE:NPLC 1", intStatus)             ' Integration time in # of Power Line Cycles (PLC)
                                                                                ' Range = 0.01 TO 10; Default = 1.0; Smaller is faster
    Call send(intDmmAddress, ":SENSE:RESISTANCE:VSCONTROL AUTO", intStatus)     ' Enable AUTO Vsource mode
    Call send(intDmmAddress, ":SENSE:RESISTANCE:AUTO:RANGE:AUTO ON", intStatus) ' Enable Autorange; first "AUTO" is optional;
                                                                                '   it is path to AUTO Vsource OHMS
    '*** CONFIGURE THE TRIGGER SUBSYSTEM
    Call send(intDmmAddress, ":ARM:SOURCE IMMEDIATE", intStatus)            ' Default value
    Call send(intDmmAddress, ":ARM:COUNT 1", intStatus)                     ' Range is 1 to 99999 or INFinite; Default is 1
    Call send(intDmmAddress, ":ARM:LAYER2:SOURCE IMMEDIATE", intStatus)     ' Default value
    Call send(intDmmAddress, ":ARM:LAYER2:COUNT 1", intStatus)              ' Range is 1 to 99999 or INF; Default is 1
    Call send(intDmmAddress, ":ARM:LAYER2:DELAY 0", intStatus)              ' Range is 0 to 999999.999 sec; Default is 0
    Call send(intDmmAddress, ":TRIGGER:COUNT " & txtNrdgs.Text, intStatus)  ' Number of readings = "txtNrdgs.Text";
                                                                            '   Range is 1 to 99999 or INF; Default is 1
    Call send(intDmmAddress, ":TRIGGER:DELAY 0", intStatus)                 ' Range is 0 to 999999.999 sec; Default is 0
    Call send(intDmmAddress, ":TRIGGER:SOURCE TIMER", intStatus)            ' Use 6517A internal TIMER as trigger source
    Call send(intDmmAddress, ":TRIGGER:TIMER " & txtDelay.Text, intStatus)  ' Time between readings = "txtDelay.Text" seconds;
                                                                            '   Range is 0 to 999999.999 sec; Default is 0.1;
                                                                            '   Timer event is automatically bypassed 1st time
    '*** CONFIGURE THE DATA BUFFER (TRACE SUBSYSTEM)
    Call send(intDmmAddress, ":TRACE:POINTS " & txtNrdgs.Text, intStatus)   ' Set Buffer Size to Number of Readings
                                                                            '   Range depends on TRACE:ELEMENTS selections
    Call send(intDmmAddress, ":TRACE:ELEMENTS TSTAMP, VSOURCE", intStatus)  ' Include timestamp and Vsource in buffer data
    Call send(intDmmAddress, ":TRACE:TSTAMP:FORMAT ABSOLUTE", intStatus)    ' Reference timestamp to first reading
       
    '*** CONFIGURE THE STATUS SUBSYSTEM
    Call send(intDmmAddress, "*CLS", intStatus)                                 ' Clear EVENT REGISTERS and ERROR QUEUE
    Call send(intDmmAddress, ":STATUS:MEASUREMENT:ENABLE 512", intStatus)       ' Set "buffer full" bit in MEAS EVENT ENABLE register
    Call send(intDmmAddress, ":STATUS:MEASUREMENT:PTRANSITION 512", intStatus)  ' Set POSITIVE TRANSITION for "buffer full" bit
    Call send(intDmmAddress, "*SRE 1", intStatus)                               ' Enable SERVICE REQUEST (SRQ)
    
    cmdStart.Enabled = True     ' Enable the Start Button
    
End Sub



Private Sub cmdStart_Click()    ' *** Subroutine performed when Start button is clicked ***
    
    Dim intPoll As Integer      ' Variable returned by Serial Poll (spoll) subroutine
    
    Call send(intDmmAddress, ":TRACE:CLEAR", intStatus)                 ' Clear the Data Buffer
    Call send(intDmmAddress, ":TRACE:FEED:CONTROL NEXT", intStatus)     ' Arm (enable) the Buffer
    Call send(intDmmAddress, ":SYSTEM:ZCHECK OFF", intStatus)            ' Turn off ZERO CHECK
    Call send(intDmmAddress, ":OUTPUT1:STATE ON", intStatus)            ' Turn ON the Voltage Source
    Call send(intDmmAddress, ":INIT", intStatus)                        ' Take 6517A out of idle,
                                                                        ' i.e. Start the measurement
    
    cmdStop.Enabled = True      ' Enable the Stop button
    
    Do                          ' Wait for buffer to fill (use a time delay if you do not want to use SRQ)
    Loop Until srq
    
    Call spoll(intDmmAddress, intPoll, intStatus)                       ' Perform serial poll and
    Call send(intDmmAddress, ":STATUS:MEASUREMENT:EVENT?", intStatus)   '   clear the "buffer full" bit
    Call enter(strBuffer, 20, lngNbytes, intDmmAddress, intStatus)      ' Enter result of query from 6517A
    
    Call cmdStop_Click          ' Perform the actions in the "cmdStop_Click" subroutine
  
End Sub

Private Sub cmdExit_Click()     ' *** Subroutine performed when Exit button is clicked ***
    
    Unload frmDemo      ' Unload the Demo form

End Sub

Private Sub cmdInstruct_Click()     ' *** Subroutine performed when Show Instructions button is clicked ***
    
    frmInstruct.Show    ' Show the Instruction form

End Sub

Private Sub cmdStop_Click()     ' *** Subroutine performed when Stop button is clicked ***
    
    Dim strNpoints As String    ' Actual number of points in buffer
    'Dim intNpoints As Integer   ' Actual number of points in buffer
    'Dim intNbytes As Long       ' Actual number of bytes sent by DMM to controller;
                                '   use to redimension input string if desired
    Dim i As Integer    ' Counter
    Dim j As Integer    ' Counter
    Dim intComma As Integer, intStart As Integer    ' Variables used for parsing strBuffer
    
    ReDim strOhmsTimeVsrc(1 To intNrdgs, 1 To 3) As String  ' Redimension array: Rows = # of rdgs and
                                                                ' Columns = 3 (Readings, Timestamp, Vsource)
    

    Call send(intDmmAddress, ":ABORT", intStatus)                       ' Stop measuring and return to idle
    Call send(intDmmAddress, ":OUTPUT1:STATE OFF", intStatus)           ' Turn OFF the Voltage Source
    Call send(intDmmAddress, ":TRACE:FEED:CONTROL NEVER", intStatus)    ' Disable the buffer
    Call send(intDmmAddress, ":TRACE:POINTS:ACTUAL?", intStatus)        ' Check how many points are in the buffer
    Call enter(strNpoints, 20, lngNbytes, intDmmAddress, intStatus)     ' Enter query result from 6517A
    
    txtPoints.Text = strNpoints     ' Fill in "Total Number of Points" textbox
    intNpoints = Val(strNpoints)
    
    Call send(intDmmAddress, ":FORMAT:ELEMENTS READING, TSTAMP, VSOURCE", intStatus)    ' Specify parameters to be
                                                                                        '   read from buffer
    Call send(intDmmAddress, ":TRACE:DATA?", intStatus)                                 ' Request buffer data
    Call enter(strBuffer, 250000, lngNbytes, intDmmAddress, intStatus)
        
    ' Enter data from buffer
    
    '*** The following parses the data string returned from the 6517A
    lstResults.Clear
        
    Dim dataArray() As String
    dataArray() = Split(strBuffer, ",")
    
        
      ' three elements per reading (R, time stp, vsource)
    For i = 0 To ((intNrdgs * 3) - 1) Step 3
      lstResults.AddItem Str(dataArray(i)) & "  " & Str(dataArray(i + 1)) & "  " & Str(dataArray(i + 2))
      
    Next i
      
    ' Fill in "Elapsed Time" textbox (time last point was measured)
    ' compute by subtracting the timestamps
    
    strBuffer = ""      ' Set strBuffer to a NULL string
    
End Sub

Private Sub Form_Load()     ' *** Subroutine performed when frmDemo is loaded ***
    ' Fill in label on frmDemo
    Label3.Caption = "* Press Config 6517A to configure the instrument." & vbCrLf _
    & "* Press Start to begin test.  Press Stop during or after measurements." & vbCrLf _
    & "* Data will be read from the Electrometer and displayed in textbox." & vbCrLf _
    & "* Enter file path and name in Data File text box and then press Save."
    
    Call initialize(21, 0)  ' Initialize Keithley (CEC) GPIB card;
                            ' initialize() subroutine is in GPIB_Subroutines Module
    
End Sub

Private Sub Form_Unload(Cancel As Integer)      ' *** Subroutine performed when frmDemo is unloaded ***
    ' When the Demo form is unloaded, reset the electrometer for front panel operation,
    ' set it to LOCAL, and then unload the Instruction form
    
    intDmmAddress = Val(txtAddress.Text)    ' Set address variable to value entered in textbox;
                                            ' do this here also in case EXIT before press EXECUTE
    
    Call send(intDmmAddress, ":system:preset", intStatus)    ' Reset the electrometer for front panel operation
    
    Call transmit("UNL LISTEN" & txtAddress.Text & "GTL UNL", intStatus)    ' Set electrometer to LOCAL;
                                                                            '   transmit() subroutine is in
                                                                            '   GPIB_Subroutines Module
    Unload frmInstruct      ' Unload the Instruction form

End Sub


Private Sub txtPoints_GotFocus()    ' Left over from original application
    txtPoints.SelStart = 0
    txtPoints.SelLength = Len(txtPoints.Text)

End Sub
